require( "quest/m1_beauty/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);	
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);		
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:SetWalkSpeed(flo_speed);
		
		actor:JumpToNamedPoint("intersection");
		actor:FaceNow(DIR.SE);
	
		actor:WalkTo("flo");
		wait_walkto();
		
		if game:Get("given_dye_to_betty") < 1 then
			actor:Face(DIR.SE);
		else
			actor:Face(DIR.S);
		end
		
		if game:Get("first_time_beauty_salon") < 1 then
			coroutine.yield(RESUME.ON_CLICK);
			run_super_conversation( actor, "conv_salon_intro" );
			game:Set("first_time_beauty_salon", 1);
			complete_quest("check_with_betty", false);
			add_quest("betty_needs_dye");
		end
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo, flo2)
		if game:Get("given_dye_to_betty") < 1 then 
			if game:Get("first_time_pet_spa") < 1 then
				convproc("FLO", "quip_flo_dye");
			else
				convproc("FLO", "conv_need_dye_and_remover");
			end
		elseif game:Get("got_dye_remover") < 1 and game:Get("first_time_pet_spa") > 0 then
			convproc("FLO", "conv_need_remover");
		elseif game:Get("mg_bead_activity_round") > 2 and game:Get("got_curtains") < 1 then
			 -- need lace curtains and haven't already picked them up
			if game:Get("clicked_curtains_in_beauty_salon") < 1 then
				convproc("FLO", "conv_need_lace");
			elseif game:Get("got_garment_pole") < 1 then
				convproc("FLO", "conv_need_curtains");
			else
				convproc("FLO", "quip_curtains_B");
				--convproc("FLO", "conv_betty_chitchat");
			end		
		else
			convproc("FLO", "quip_flo_hair");
		end
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function betty_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("given_dye_to_betty") < 1 then
		if game:Get("first_time_pet_spa") < 1 then
			run_super_conversation(flo, "conv_betty_need_dye");
		else
			run_super_conversation(flo, "conv_need_dye_and_remover");
		end
	elseif game:Get("got_dye_remover") < 1 and game:Get("first_time_pet_spa") > 0 then
		run_super_conversation(flo, "conv_need_remover");
	elseif game:Get("mg_bead_activity_round") > 2 and game:Get("got_curtains") < 1 then
		 -- need lace curtains and haven't already picked them up
		if game:Get("clicked_curtains_in_beauty_salon") < 1 then
			run_super_conversation(flo, "conv_need_lace");
		elseif game:Get("got_garment_pole") < 1 then
			run_super_conversation(flo, "conv_need_curtains");
		else
			--run_super_conversation(flo, "conv_betty_chitchat");
			run_super_conversation(flo, "quip_curtains_B");
		end
	else
		run_super_conversation(flo, "conv_betty_chitchat");
	end
		
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function give_betty_dye(flo)
	flo:SetMode(MODE.CUTSCENE);
	BAG_INV:RemoveInventory("dye");
	game:Set("given_dye_to_betty", 1);
	run_super_conversation(flo, "conv_give_dye");
	
	--scene.BETTY:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	--scene.BETTY:PlayAnim("DoStandE");
	--scene.BETTY_ARM:Expire();
	
	add_quest("check_supply_drawers", false);
	complete_quest("betty_needs_dye", false);
	complete_quest("give_betty_dye");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function playbettyidle(betty)
	local idle_delay = 0;
	while true do
		if scene.FLO:GetMode() == MODE.FOLLOWCLICKS then
			if game:Get("given_dye_to_betty") < 1 then
				betty:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
				betty:PlayAnim("Idle");
				betty:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
				delay(200);
			else
				if idle_delay < 1 then
					betty:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
					betty:PlayAnim("Idle" .. math.random(1, 2));
					--wait_anim();
					betty:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
					idle_delay = math.random(150, 200);
				else
					idle_delay = idle_delay - 1;
				end
			end
			delay(1);
		else
			delay(1);
		end
	end
end

betty_spec = 
{
	name = "BETTY";
	
	command = function(actor)
		prepare_actor_text(actor, betty_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(betty_speed);
		
		if game:Get("given_dye_to_betty") < 1 then
			actor:LoadZone("quest/objects/betty_search");
			actor:LoadAnimFile("anim/loretta/search");
			actor:JumpToNamedPoint("loretta_search");
			actor:FaceNow(DIR.W);
			actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			actor:PlayAnim("Idle");
			delay(2);
			actor:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		else
			actor:LoadZone("quest/objects/lorettas");
			actor:LoadAnimFile("anim/loretta/idle1");
			actor:LoadAnimFile("anim/loretta/idle2");
			actor:LoadAnimFile("anim/loretta/stand");
			actor:LoadAnimFile("anim/loretta/talkw");
			actor:JumpToNamedPoint("loretta");
			actor:FaceNow(DIR.W);
			actor:PlayAnim("DoStandW");
		end
		actor:StartProc(playbettyidle);
	end;
	
	on_arrive = function(flo, betty)
		flo:StartProc(betty_conv);
	end;
	
	on_use_inv = function(item, flo, betty)
		if item == "dye" then
			flo:StartProc(give_betty_dye);
		else
			if game:Get("given_dye_to_betty") < 1 then
				convproc("FLO", "quip_betty_reject_A");
			else
				convproc("FLO", "quip_betty_reject_B");
			end
		end
		
		return RESPONSE.INV_HANDLED;
	end;
};

bridesmaid_spec = 
{
	name = "BRIDESMAID";
	gfx = { anim = "anim/bridesmaid/stand" };
	
	command = function(actor)
		--actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("bridesmaid");
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:FaceNow(DIR.E);
	end;
}

function clickbox(flo)
end

box_spec = 
{
	name = "BOX";
	halo = "box";
	gfx = { image = "box" };
	
	command = function(actor)
		actor:SetDepthValue(450);
	end;
	
	on_arrive = function(flo, box)
		flo:StartProc(clickbox);
	end;
}

function gotointersection(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("intersection");
	wait_walkto();
	
	goto_scene(flo, "m1_intersection");
end

to_intersection = 
{
	name = "TO_INTERSECTION";
	halo = "door_intersection";
	cursor = "cursor_arrow_n";
	goto_fn = gotointersection;
}

chairs_spec = 
{
	name = "CHAIRS";
	halo = "chairs";
	
	command = function(actor)
	end;
	
	on_arrive = function(flo, chairs)
		convproc("FLO", "quip_chair");
	end;
}

circle_shelf_spec = 
{
	name = "CIRCLE_SHELF";
	halo = "circle_shelf";
	
	command = function(actor)
	end;
	
	on_arrive = function(flo, circle_shelf)
		convproc("FLO", "quip_circle_shelf");
	end;
}

function get_curtains(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("given_dye_to_betty") < 1 then
		run_super_conversation(flo, "quip_curtains_A");
	elseif game:Get("get_curtains_from_beauty_salon") < 1 or BAG_INV:CheckInventory("garmentpole") then
		run_super_conversation(flo, "quip_curtains_B");
		game:Set("get_curtains_from_beauty_salon", 1);
	else
		run_super_conversation(flo, "quip_curtains_C");
	end
	
	if game:Get("clicked_curtains_in_beauty_salon") < 1 then
		add_quest("beauty_curtains", false);
		add_quest("use_pole");
	end
	
	game:Set("clicked_curtains_in_beauty_salon", 1);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function use_pole_on_curtains(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("given_dye_to_betty") < 1 then
		run_super_conversation(flo, "quip_curtains_A");
	else
		scene.FLO:WalkTo("curtains");
		wait_walkto(scene.FLO);
		scene.FLO:Face(DIR.SE);
		delay(30);
		BAG_INV:RemoveInventory("garmentpole");
		scene.CURTAINS:Expire();
		addInventory(inv_desc_curtains);
		game:Set("got_curtains", 1);
		run_super_conversation(flo, "quip_pickup_curtains");
		complete_quest("beauty_curtains", false);
		complete_quest("use_pole");
		scene.FLO:WalkTo("flo");
		wait_walkto(scene.FLO);
		if game:Get("given_dye_to_betty") < 1 then
			scene.FLO:Face(DIR.SE);
		else
			scene.FLO:Face(DIR.S);
		end
	end
	
	game:Set("clicked_curtains_in_beauty_salon", 1);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

curtains_spec = 
{
	name = "CURTAINS";
	halo = "curtains";
	gfx = { anim = "anim/m1_beauty/curtains" };
	
	command = function(actor)
		actor:SetDepthValue(200);
		actor:PlayAnim("curtains");
	end;
	
	on_arrive = function(flo, curtains)
		flo:StartProc(get_curtains);
	end;
	
	on_use_inv = function(item, flo, curtains)
		if item == "garmentpole" then
			flo:StartProc(use_pole_on_curtains);
		else
			convproc("FLO", "quip_curtains_reject");
		end
		
		return RESPONSE.INV_HANDLED;
	end;
}

function open_drawer(flo, drawers)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("opened_beauty_salon_drawers") < 1 then
		run_super_conversation(flo, "quip_drawer_C");
		game:Set("opened_beauty_salon_drawers", 1);
	end;
	sfx:PlaySFX("audio/sfx/drawer_open.ogg");
	scene.DRAWERS:PlayAnim("open");
	delay(3);
	
	scene:ChainToSubScene("m1_beautydrawer");
	wait_subscene();
	
	raise_hud();
	
	scene.DRAWERS:PlayAnim("closed");
	
	if game:Get("got_dye_remover") == 1 and not quest_complete("check_supply_drawers") then
		scene:Spawn(big_dye_spec);
		while not hud_raised() do
			delay(1);
		end
		scene.BIG_DYE:Expire();
		addInventory(inv_desc_dyeremover);
		complete_quest("check_supply_drawers", false);
		complete_quest("need_dye_remover", false);
		add_quest("bring_dye_to_petspa");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

drawers_spec = 
{
	name = "DRAWERS";
	halo = "drawers";
	gfx = { anim = "anim/m1_beauty/drawer" };
	
	command = function(actor)
		actor:SetDepthValue(DEPTH.FRONTMOST);
		actor:PlayAnim("closed");
	end;
	
	on_arrive = function(flo, drawers)
		if game:Get("given_dye_to_betty") < 1 then 
			if game:Get("clicked_on_beauty_salon_drawers") < 1 then
				convproc("FLO", "quip_drawers_A");
				game:Set("clicked_on_beauty_salon_drawers", 1);
			else
				convproc("FLO", "quip_drawers_B");
			end
		elseif game:Get("got_dye_remover") < 1 then
			flo:StartProc(open_drawer);
		else
			convproc("FLO", "quip_drawer_D");
		end
	end;
}

ambient_spec = 
{
	name = "AMBIENT";
	gfx = { anim = "anim/m1_beauty/ambient" };
	
	command = function(actor)
		actor:SetDepthValue(10);
		actor:PlayAnim("ambient");
	end;
}

other_bottles_spec = 
{
	name = "OTHER_BOTTLES";
	halo = "other_bottles";
	
	command = function(actor)
		actor:SetDepthValue(depth);
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(
			function(flo)
				flo:SetMode(MODE.CUTSCENE);
				run_super_conversation(flo, "quip_not_dye_remover_a");
				flo:SetMode(MODE.FOLLOWCLICKS);
			end
		)
	end;
}

hair_posters_spec = 
{
	name = "HAIR_POSTERS";
	halo = "hair_posters";
	
	command = function(actor)
	end;
	
	on_arrive = function(flo, hair_posters)
		convproc("FLO", "quip_hair_poster");
	end;
}

left_shelf_spec = 
{
	name = "LEFT_SHELF";
	halo = "left_shelf";
	
	command = function(actor)
	end;
	
	on_arrive = function(flo, left_shelf)
		convproc("FLO", "quip_left_shelf");
	end;
}

big_dye_spec = 
{
	name = "BIG_DYE";
	gfx = { image = "popup/pop_inv_dyeremover" };
	
	command = function(actor)
		actor:SetDepthValue(600);
		
		local imageSize = actor:GetImageSize();
		local popupLocation = { x = 400 - (imageSize.x / 2), y = 300 - (imageSize.y / 2) };
		
		actor:JumpToPoint(popupLocation);
	end;
};

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/beautysalonmusic.ogg", true);
		scene:SetRoomScale(200, 400, 0.9, 1.0);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
			-- BAG_INV:AddInventory(inv_desc_dye);
			--BAG_INV:AddInventory(inv_desc_garmentpole);
			--game:Set("got_garment_pole", 1);
			--game:Set("first_time_beauty_salon", 1);
			--game:Set("first_time_pet_spa", 1);
			--game:Set("mg_bead_activity_round", 3)
			--game:Set("got_dye_remover", 1);
			--game:Set("got_curtains", 1);
			--game:Set("given_dye_to_betty", 1);
			--game:Set("mg_bead_activity_round", 3);
			--game:Set("got_garment_pole", 1);
			--complete_quest("check_with_walter", false);
		end
		
		if game:Get("got_curtains") < 1 then
			scene:Spawn(curtains_spec);
		end
		
		if game:Get("given_dye_to_betty") > 0 then
			scene:Spawn(bridesmaid_spec);
		end
		
		spawn_nav_arrow(to_intersection);
		
		game:SetString("map_position", "m1_beauty");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "front1", 450 },
		{ "front2", 450 },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		betty_spec,
		--box_spec,
		chairs_spec,
		circle_shelf_spec,
		drawers_spec,
		hair_posters_spec,
		left_shelf_spec,
		ambient_spec,
		other_bottles_spec,
		
		scene_setup,
	};
};
